<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    * 
    * Visualizzatore del componente griglia contenuti. 
    * 
    * Nota: questo componente originariamente si chiamava griglia immagini, per motivi di
    * retrocompatibilità la classe qui sotto non è stata rinominata
    */

    class VisualizzatoreGrigliaImmagini extends VisualizzatoreComponente {
        
        private $datiGriglia;
        private $classeContenitore;
        
        function __construct($db) {
            parent::__construct($db);
            $this->classeContenitore = "";
        }
        
        function generaContenutoSezione($dati) {
            $this->datiGriglia = parent::getDb()->leggiSingolaRiga("geec_griglieImmagini",$dati["idElemento"]);
            
            echo"<div class=\"{$this->datiGriglia["spazioOccupato"]}\">
                    <div class=\"row\">
                        <div class=\"col-md-12 mb-3 text-center\">
                            <h2 class=\"separatore-inferiore\">{$this->datiGriglia["nome"]}</h2>
                            <p class=\"lead\">{$this->datiGriglia["descrizione"]}</p>
                        </div>
                    </div>";

                    //creazione elementi portfolio
                    $querySlide="SELECT * FROM geec_immaginiGriglia WHERE idGriglia={$dati["idElemento"]} ORDER BY posizione ASC";
                    $risElementi = parent::getDb()->eseguiQueryLettura($querySlide);

                    if($risElementi->num_rows==0) {
                        echo"<h2>Attenzione, non sono presenti elementi in questa immagini. Crearli dal pannello amministrativo</h2>";
                    }

                    echo"<div class=\"row griglia-immagini d-flex justify-content-center {$this->datiGriglia["animazioneOnHover"]}\">";
                    while($elemento=$risElementi->fetch_assoc()) {
                        if($elemento["link"]!="") {
                            $this->stampaElementoConLink($elemento,$this->datiGriglia["classeElementi"]);
                        }
                        else {
                            $this->stampaElementoSenzaLink($elemento,$this->datiGriglia["classeElementi"]);
                        }
                    }
            echo"</div>
                </div>";
        }
        
        function stampaElementoConLink($elemento,$classeBase) {
            echo"<div class=\"$classeBase {$elemento["classeElemento"]} mb-3\">
                <a href=\"{$elemento["link"]}\">
                    <img class=\"img-fluid w-100\" src=\"{$elemento["percorsoImmagine"]}\" alt=\"{$elemento["tagAltImmagine"]}\">
                    <h5 class=\"text-center mt-3\">{$elemento["nome"]}</h5>
                    {$elemento["descrizione"]}
                </a>
            </div>";
        }
        
        function stampaElementoSenzaLink($elemento, $classeBase) {
            echo"<div class=\"$classeBase {$elemento["classeElemento"]} mb-3\">
                    <img class=\"img-fluid w-100\" src=\"{$elemento["percorsoImmagine"]}\" alt=\"{$elemento["tagAltImmagine"]}\">
                    <h5 class=\"text-center mt-3\">{$elemento["nome"]}</h5>
                    {$elemento["descrizione"]}
            </div>";
        }
        
        function getJavascriptAssociato() {
            return "";
        }

        /*
         * Questa funzione serve quando viene stampato il componente in un articolo o in un prodotto
         */
        function inizializzaVariabiliComponente($dati) {
            $this->datiGriglia = parent::getDb()->leggiSingolaRiga("geec_griglieImmagini",$dati["idElemento"]);
        }
    }